#!/usr/bin/env bash
#
# Convenience wrapper to run the kernel→metric simulation over all
# conditions defined in the YAML configuration and aggregate the
# results.  This script should be executed from the root of the
# repository.  It assumes that the Python package is importable (either
# because the repo is on ``PYTHONPATH`` or installed in the active
# environment).

set -euo pipefail

# Run the simulation for all anchors
# Prepend src/ to PYTHONPATH so that the package ``k2m`` can be imported
PYTHONPATH="src:${PYTHONPATH:-}" python -m k2m.run_all --config configs/anchors.yaml --data-dir data --output runs

# Aggregate the JSON outputs into CSV and Parquet
PYTHONPATH="src:${PYTHONPATH:-}" python scripts/aggregate.py runs --output_prefix runs/summary

echo "All conditions completed.  Results are stored in the 'runs' directory."
